<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\OrderReportScheme;
use model\Customers;
use model\Entity\CustomersEntity;
use model\Entity\IndividualsEntity;
use model\Entity\StartupsEntity;
use model\Entity\StartupUsersEntity;
use model\Individuals;

class TransactionReports extends OrderReportScheme
{
    public function getReport()
    {
        ob_start();
        $startup_id = $this->isSet('startup_id', function ($startup_id) {
            if (is_numeric($startup_id) and $startup_id > 0) {
                return $startup_id;
            }
            return null;
        });

        $customer_id = $this->isSet('customer_id', function ($customer_id) {
            if (is_numeric($customer_id) and $customer_id > 0) {
                return $customer_id;
            }
            return null;
        });

        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == null) {
                return null;
            }
            return persianStrToTime($date_from);
        });

        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == null) {
                return null;
            }
            return persianStrToTime($date_to);
        });

        $type = $this->isSet('type', function ($type) {
            if ($type == null) {
                return null;
            }
            return $type;
        });

        $output = [];
        $result = \model\TransactionReports::getReport($startup_id, $customer_id, $start_date, $end_date, $type);
        /** @var StartupUsersEntity $startupUser */
        /** @var CustomersEntity $customer */
        /** @var IndividualsEntity $individual */
        /** @var StartupsEntity $startUp */

        foreach ($result as $transaction) {
            $type = '-';
            $sBefore = $transaction->score_before; //امتیاز پیشین
            $sAfter = $transaction->score_after;//امتیاز جدید
            $cBefore = $transaction->credit_before;//اعتبار پیشین
            $cAfter = $transaction->credit_after;//اعتبار جدید
            $sTOs = $transaction->score_to_club_score;//امتیاز به امتیاز نگاهاب
            $sFs = $transaction->club_score_from_score;//امتیاز نگاهاب از امتیاز استارت آپ
            $sTOc = $transaction->score_to_club_credit;// امتیاز به اعتبار نگاهاب
            $cFs = $transaction->club_credit_from_score;// اعتبار نگاهاب از امتیاز استارت آپ
            $cTOs = $transaction->credit_to_club_score;// اعتبار به امتیاز نگا گلاب
            $sFc = $transaction->club_score_from_credit;// امتیاز نگاهاب از اعتبار استارت آپ

            if ($sBefore !== $sAfter && $sTOs == NULL && $sFs == NULL && $sTOc == NULL && $cFs == NULL && $cTOs == NULL && $sFc == NULL) {
                $type = 'تخصیص امتیاز';
            } else if ($cBefore !== $cAfter && $sTOs == NULL && $sFs == NULL && $sTOc == NULL && $cFs == NULL && $cTOs == NULL && $sFc == NULL) {
                $type = 'تخصیص اعتبار';
            } else if ($sTOs !== $sFs && $sTOc == 0 && $cFs == 0 && $cTOs == 0 && $sFc == 0) {
                $type = 'تبدیل امتیاز به امتیاز نگاهاب';
            } else if ($sTOc !== $cFs && $sTOs == 0 && $sFs == 0 && $cTOs == 0 && $sFc == 0) {
                $type = 'تبدیل امتیاز به اعتبار نگاهاب';
            } else if ($cTOs !== $sFc && $sTOs == 0 && $sFs == 0 && $sTOc == 0 && $cFs == 0) {
                $type = 'تبدیل اعتبار به امتیاز نگاهاب';
            } else if ($sTOs !== $sFs && $sTOc !== $cFs && $cTOs == 0 && $sFc == 0) {
                $type = 'تبدیل امتیاز به امتیاز نگاهاب' . '-' . 'تبدیل امتیاز به اعتبار نگاهاب';
            } else if ($sTOs !== $sFs && $sTOc == 0 && $cFs == 0 && $cTOs !== $sFc) {
                $type = 'تبدیل امتیاز به امتیاز نگاهاب' . '-' . 'تبدیل اعتبار به امتیاز نگاهاب';
            } else if ($cTOs !== $sFc && $sTOs == 0 && $sFs == 0 && $sTOc !== $cFs) {
                $type = 'تبدیل امتیاز به اعتبار نگاهاب' . '-' . 'تبدیل اعتبار به امتیاز نگاهاب';
            } else if ($cTOs !== $sFc && $sTOs !== $sFs && $sTOc !== $cFs) {
                $type = 'تبدیل امتیاز به امتیاز نگاهاب' . '-' . 'تبدیل امتیاز به اعتبار نگاهاب' . '-' . 'تبدیل اعتبار به امتیاز نگاهاب';
            }
            

            $customer = Customers::get($transaction->customer_id);
            $individual = Individuals::get($customer->individual_id);
            $startUp = \model\Startups::get($transaction->startup_id);
            $output[] = [
                'startUpName' => $startUp->name,
                'fullName' => $individual->first_name . ' ' . $individual->last_name . ' - ' . $individual->mobile,
                'date' => jdate("Y/m/d H:i", strtotime($transaction->transaction_historys_create)),
                'score_before' => $transaction->score_before,
                'score_after' => $transaction->score_after,
                'credit_before' => $transaction->credit_before,
                'credit_after' => $transaction->credit_after,
                'type' => $type,
            ];

        }

        $TransactionReportsView = new \view\TransactionReports($this);
        echo $TransactionReportsView->makeRow(
            $output
        );
        $content = ob_get_clean();
        return json_encode([
            'status' => true,
            'html' => $content,
        ]);
    }

    protected function setModel(Model $model = null): void
    {
        $this->model = new Customers();
        $this->setKey($this->model->_key);
    }
}
