<?php

namespace controller;

use DATABASE\Model;
use model\Individuals;
use model\Entity\StartupsEntity;
use FwBase\Reports\ReportScheme;
use model\Entity\ProvidersEntity;
use model\Entity\IndividualsEntity;
use model\Entity\StartupUsersEntity;

class ProviderReports extends ReportScheme {
	
	
	public function getReport() {
		ob_start();
		$startup_id = $this->isSet('startup_id', function ($startup_id) {
			if (is_numeric($startup_id) and $startup_id > 0) {
				return $startup_id;
			}
			return NULL;
		});
		$provider_id = $this->isSet('provider_id', function ($provider_id) {
			if (is_numeric($provider_id) and $provider_id > 0) {
				return $provider_id;
			}
			return NULL;
		});
		$start_date = $this->isSet('date_from', function ($date_from) {
			if ($date_from == NULL) {
				return NULL;
			}
			return persianStrToTime($date_from);
		});
		$end_date = $this->isSet('date_to', function ($date_to) {
			if ($date_to == NULL) {
				return NULL;
			}
			return persianStrToTime($date_to);
		});
		$output = [];
		$result = \model\ProviderReports::getReport($start_date, $end_date, $startup_id, $provider_id);
		/** @var StartupUsersEntity $startupUser */
		/** @var ProvidersEntity $provider */
		/** @var IndividualsEntity $individual */
		/** @var StartupsEntity $startUp */
		foreach ($result as $startupProvider) {
			$startup = \model\Startups::get($startupProvider->startup_id);
			$provider = \model\Providers::get($startupProvider->provider_id);
			$individual = Individuals::get($provider->provider_manager);
			$output[] = [
				'startUpName'    => $startup->name,
				'providerName'   => $provider->name,
				'manager'        => $individual->first_name . ' ' . $individual->last_name,
				'dateStart'      => jdate("Y/m/d H:i", ($startupProvider->provider_to_startup_start_date)),
				'dateEnd'        => jdate("Y/m/d H:i", ($startupProvider->provider_to_startup_end_date)),
				'cashDiscount'   => $startupProvider->provider_to_startup_cash_discount,
				'creditDiscount' => $startupProvider->provider_to_startup_credit_discount,
			];
		}
		$ProviderReportsView = new \view\ProviderReports($this);
		echo $ProviderReportsView->makeRow(
			$output
		);
		$content = ob_get_clean();
		return json_encode([
			'status' => true,
			'html'   => $content,
		]);
	}

//    public function getReport()
//    {
//        ob_start();
//        $start_date = $this->isSet('date_from', function ($date_from) {
//            if ($date_from == null){
//                return null;
//            }
//            return persianStrToTime($date_from);
//        });
//        $end_date = $this->isSet('date_to', function ($date_to) {
//            if ($date_to == null){
//                return null;
//            }
//            return persianStrToTime($date_to);
//        });
//        $startup_id = $this->isSet('startup_id',function ($startup_id){
//            if (is_numeric($startup_id) and $startup_id > 0){
//                return $startup_id;
//            }
//            return null;
//        });
//
//        $rF = "";
//        $mProviderReports = new \model\ProviderReports();
//        $report = $mProviderReports->getReport($start_date, $end_date, $startup_id);
//
//        if (count($report)) {
//
//            $tmp_table_body = '';
//            foreach ($report as $r) {
//                $tmp_table_body .=
//                    HtmlTags::Tr('.children-overflow')->Content(
//                        HtmlTags::Td($r['index']),
//                        HtmlTags::Td($r['startup']),
//                        HtmlTags::Td($r['Provider']),
//                        HtmlTags::Td($r['manager']),
//                        HtmlTags::Td($r['dateStart']),
//                        HtmlTags::Td($r['dateEnd']),
//                        HtmlTags::Td($r['cashDiscount']),
//                        HtmlTags::Td($r['creditDiscount']),
//                        HtmlTags::Td($r['desc'])
////                        HtmlTags::Td(HtmlTags::Button('.btn.btn-outline-warning.m-1.ajax')->Content(
////                            HtmlTags::I('.fa.fa-camera')
////                        )->Data_('toggle', 'tooltip')->Title('تصاویر نام محصول')->Rel((new \controller\GalleryProductName())->RelPath(['product_id' => $r['desc']
////                        ])))
//
//                    );
//            }
//            $rF .= HtmlTags::Table('.table.table-bordered.table-striped.d-inline-table')
//                ->Id('table')
//                ->Content(
//                    HtmlTags::Thead('.table-dark')
//                        ->Content(
//                            HtmlTags::Tr('.children-overflow')->Content(
//                                HtmlTags::Th('ردیف'),
//                                HtmlTags::Th('استارت آپ'),
//                                HtmlTags::Th('پذیرنده'),
//                                HtmlTags::Th('مدیریت'),
//                                HtmlTags::Th('تاریخ شروع قرارداد'),
//                                HtmlTags::Th('تاریخ پایان قرارداد'),
//                                HtmlTags::Th('تخفیف نقدی'),
//                                HtmlTags::Th('تخفیف اعتباری'),
//                                HtmlTags::Th('جزئیات ')
//                            )
//                        ),
//                    HtmlTags::Tbody('.table-white')
//                        ->Content(
//                            $tmp_table_body
//                        )
//                );
//        }
//        else $rF = HtmlTags::H4('متاسفانه گزارشی موجود نیست!');
//
//        return $rF;
//    }
	protected function setModel(Model $model = NULL) : void {
		$this->model = new \model\Providers();
		$this->setKey($this->model->_key);
	}
	
	
}
