<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use FwBase\Reports\OrderReportScheme;
use model\Customers;
use model\Entity\CustomersEntity;
use model\Entity\IndividualsEntity;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;
use model\Entity\StartupUsersEntity;
use model\Individuals;

//use FwBase\Reports\OrderReportScheme;

class CustomerReports extends ReportScheme
{


    public function getReport()
    {
        ob_start();

        $startup_id = $this->isSet('startup_id', function ($startup_id) {
            if (is_numeric($startup_id) and $startup_id > 0) {
                return $startup_id;
            }
            return null;
        });

        $customer_id = $this->isSet('customer_id', function ($customer_id) {
            if (is_numeric($customer_id) and $customer_id > 0) {
                return $customer_id;
            }
            return null;
        });

        $level_id = $this->isSet('level_id', function ($level_id) {
            if (is_numeric($level_id) and $level_id > 0) {
                return $level_id;
            }
            return null;
        });

        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == null) {
                return null;
            }
            return persianStrToTime($date_from);
        });

        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == null) {
                return null;
            }
            return persianStrToTime($date_to);
        });
        $start_credit = $this->isSet('credit_from', function ($credit_from) {
            if ($credit_from == null) {
                return null;
            }
            return $credit_from;
        });
        $end_credit = $this->isSet('credit_to', function ($credit_to) {
            if ($credit_to == null) {
                return null;
            }
            return $credit_to;
        });
        $start_score = $this->isSet('score_from', function ($score_from) {
            if ($score_from == null) {
                return null;
            }
            return $score_from;
        });
        $end_score = $this->isSet('score_to', function ($score_to) {
            if ($score_to == null) {
                return null;
            }
            return $score_to;
        });

        $output = [];
        $result = \model\CustomerReports::getReport($start_date, $end_date, $startup_id, $start_credit, $end_credit, $start_score, $end_score, $level_id,$customer_id);
        /** @var StartupUsersEntity $startupUser */
        /** @var CustomersEntity $customer */
        /** @var IndividualsEntity $individual */
        /** @var StartupsEntity $startUp */
        /** @var LevelsEntity $level */

        foreach ($result as $startupUser) {
            $customer = Customers::get($startupUser->customer_id);
            $individual = Individuals::get($customer->individual_id);
            $startUp = \model\Startups::get($startupUser->startup_id);
            $level = \model\Levels::get($customer->level_id);

            $output[] = [
                'startUpName' => $startUp->name,
                'fullName' => $individual->first_name . ' ' . $individual->last_name . ' - ' . $individual->mobile,
                'date' => jdate("Y/m/d H:i", strtotime($startupUser->create)),
                'credit' => $startupUser->credit,
                'score' => $startupUser->score,
                'level' => $level->title,

            ];

        }
        $CustomerReportsView = new \view\CustomerReports($this);

        return json_encode([
            'status' => true,
            'html' => $CustomerReportsView->makeRow(
                $output
            ),
        ]);
    }

    protected function setModel(Model $model = null): void
    {
        $this->model = new Customers();
        $this->setKey($this->model->_key);
    }


}
