<?php
namespace controller;
use DATABASE\Model;
use FwBase\Reports\OrderReportScheme;
use model\Agencies;
use model\Customers;
use model\Entity\AgenciesEntity;
use model\Entity\IndividualsEntity;
use model\Entity\SupervisionsEntity;
use model\Individuals;

class AgencyReports extends OrderReportScheme
{
    public function getReport()
    {
        ob_start();
        $agency_name = $this->isSet('agency_id', function ($agency_name) {
            if (is_numeric($agency_name) and $agency_name > 0) {
                return $agency_name;

            }
            return null;
        });
        $manager_name = $this->isSet('individual_id', function ($manager_name) {
            if (is_numeric($manager_name) and $manager_name > 0) {
                return $manager_name;

            }
            return null;
        });

        $supervision_name = $this->isSet('supervision_id', function ($supervision_name) {
            if (is_numeric($supervision_name) and $supervision_name > 0) {
                return $supervision_name;

            }
            return null;

        });



        $output = [];
        $result = \model\AgencyReports::getReport($agency_name,$supervision_name,$manager_name);
        /** @var AgenciesEntity $agencies */
        /** @var SupervisionsEntity $supervisions */
        /** @var IndividualsEntity $manager*/
        foreach ($result as $agency) {
            $individual = Individuals::get($agency->individual_id);
            $supervision = \model\Supervisions::get($agency->supervision_id);

            $output[] = [
                'agencyName' => $agency->name,
                'managerName' => $individual->first_name . ' ' . $individual->last_name . ' - ' . $individual->mobile,
                'supervisionName' => $supervision->supervision_name,
            ];

        }

        $AgencyReportsView = new \view\AgencyReports($this);
        return json_encode([
            'status' => true,
            'html' => $AgencyReportsView->makeRow(
                $output
            ),
        ]);
    }
    protected function setModel(Model $model = null): void
    {
        $this->model = new Customers();
        $this->setKey($this->model->_key);
    }
}