<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use model\Entity\ProvidersEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwPagination\Controllers\ControllersPagination;

class Providers extends ControllerScheme {
	use ControllersPagination;
	
	const name = 'پذیرنده';
	
	public static $__uploads = ["provider_image" => __SOURCE__ . "images/Providers/"];
	
	use ApiInterface;
	

public function getProvidersNotInStartup() {
		$startup_id = $this->requestArray()['startup_id'];
		$type = $_POST['type'];
		$output = [
			HtmlTags::Option()->Selected()->Disabled()->Content("لطفا یک مورد را انتخاب کنید"),
		];
		foreach (\model\Providers::getAllNotInStartUp($startup_id) as $item) {
			if (isActive($this, $item)) {
				$output[] = HtmlTags::Option()->Value($item->provider_id)->Content($item->name);
			}
		}
		if (isset($type) and $type == 'edit') {
			$output = [
				HtmlTags::Option()->Selected()->Disabled()->Content("لطفا یک مورد را انتخاب کنید"),
			];
			foreach (\model\Providers::getAll() as $item) {
				if (isActive($this, $item)) {
					$output[] = HtmlTags::Option()->Value($item->provider_id)->Content($item->name);
				}
			}
		}
		return implode('', $output);
	}


//	public function main() {
//
//		if ($this->requestArray()['provider_id'] > 0) {
//			return $this->view($this->viewName(), 'main', [
//				$this->model()->getAllFiltered('provider_id', $this->requestArray()['provider_id']),
//			]);
//		}
//		return parent::main();
//	}
	public function singleProvider() {
		
		$providerId = $this->ApiParam('providerId');
		/** @var ProvidersEntity $provider */
		$provider = $this->model()::get($providerId);
		return $provider->singleApiFormat();
	}
	
	public function allProvidersbycaste() {
		
		$casteId = $this->ApiParam('casteId');
		$output = [];
		/** @var ProvidersEntity $caste */
		$caste = $this->model()::getAllFiltered('caste_id', $casteId);
		foreach ($caste as $item) {
			$output[] = $item->apiFormat();
		}
		return $output;
	}
	
}
