<?php

namespace controller;

use ControllerScheme;
use payment\BasePayment;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;
use model\Entity\CustomersEntity;
use model\Entity\StartupUsersEntity;
use model\Entity\ProviderToStartupEntity;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

class ProviderPayments extends ControllerScheme {
	const name = 'پرداخت به پذیرنده';
	
	public function paymentCallBack($post, BasePayment $Payment, $PaymentData) {
		$resNum = $post['OrderId'];
		$Status = $post['status'];
		$refNum = $post['RRN'];
		$Token = $post['Token'];
		if ($Status === '0') {
			$Payment->update($resNum, $refNum);
			$Payment->Confirm($Token);
			self::Update($PaymentData->payment_id, '1');
			/** @var CustomersEntity $customer */
			$customer = \model\Customers::get($PaymentData->customer_id);
			$providerPayment = (new Db('tblProviderPayments'))->where('payment_id', $PaymentData->payment_id)->get()->first;
			/** @var StartupsEntity $startup */
			$startup = \model\Startups::get($providerPayment->startup_id);
			/** @var StartupUsersEntity $startupUser */
			$startupUser = \model\StartupUsers::getByStartup($customer->customer_id, $startup);
			/** @var LevelsEntity $level */
			$level = \model\Levels::get($startupUser->level_id);
			/** @var ProviderToStartupEntity $provider */
			$provider = \model\ProviderToStartup::getByStartup($providerPayment->provider_id, $startup);
			$amount = $providerPayment->provider_payment_real_amount;
			$providerDiscountPercent = $provider->to_startup_cash_discount;
			$provider->credit = ($providerDiscountPercent * $amount) / 100;
			$provider->save();
			$providerPercent = ($provider->to_startup_cash_discount - ($startup->startup_hub_percent + $startup->startup_percent));
			$providerPercent = $providerPercent >= 0 ? $providerPercent : 0;
			/** @var LevelsEntity $currentLevel */
			$changes = [];
			for ($i = 1; $i <= $startup->referral_count; $i++) {
				if (str($startupUser->parent)->len() > 0) {
					$parent = \model\StartupUsers::getByMobile($startupUser->mobile);
					if ($parent instanceof StartupUsersEntity) {
						$currentLevel = $parent->level_id;
						$currentLevel = \model\Levels::get($currentLevel);
						$percent = ($currentLevel->discount_percent * $providerPercent) / 100;
						$finalAmount = (($percent * $amount) / 100);
						$parent->credit += $finalAmount;
						$changes[$parent->mobile] = $parent->credit;
						$parent->save();
						if (str($parent->parent)->len() > 0) {
							$startupUser = $parent;
						} else {
							break;
						}
					} else {
						break;
					}
				} else {
					break;
				}
			}
			CallAPI('post', 'https://api.negaclub.ir/changeUserCredit', $changes, ['Content-Type' => 'application/json'], true);
			CallAPI('post', 'https://api.negaclub.ir/changeProviderCredit', [
				'mobile' => $provider->getMobile()
			], ['Content-Type' => 'application/json'], true);
			return $this->CallCallBack($resNum, true, $PaymentData);
		} else {
			self::Update($PaymentData->payment_id, '0');
			return $this->CallCallBack($resNum, false, $PaymentData);
		}
	}
	
	public static function Update($payment_id, string $string) {
		
		return (new Db('tblProviderPayments'))->where('payment_id', $payment_id)->update([
			'provider_payment_status' => $string,
		]);
	}
	
	private function CallCallBack($resNum, bool $status, $PaymentData) {
		$Db = new Db('tblProviderPayments');
		$providerId = $Db->where("payment_id", $PaymentData->payment_id)->get()->first()->provider_id;
		$mobile = $PaymentData->mobile;
		$callback = $this->getCallBackUrl($PaymentData->payment_id);
		$status = $status ? 'true' : 'false';
		var_dump($callback);
		return "<form action='{$callback}' id='SubmitForm' method='post' >
<input type='hidden' name='status' value='$status'>
<input type='hidden' name='mobile' value='$mobile'>
<input type='hidden' name='resNum' value='$resNum'>
<input type='hidden' name='providerId' value='$providerId'>
</form>
<script>document.getElementById('SubmitForm').submit();</script>
";
		//
	}
	
	private function getCallBackUrl($payment_id) {
		
		return $this->model()::Db()->where("payment_id", $payment_id)->get()->first()->callback;
	}
	
}
