<?php

namespace controller;

use ControllerScheme;
use Api\ApiInterface;
use model\Entity\StartupsEntity;
use model\Entity\ProvidersEntity;
use model\Entity\ProviderBranchesEntity;
use model\Entity\ProviderToStartupEntity;
use FwPagination\Controllers\ControllersPagination;

class ProviderToStartup extends ControllerScheme {
	use ApiInterface;
	use ControllersPagination;
	
	const name = 'تخصیص پذیرنده به استارت آپ';
	
	protected static $__uploads = [
		'provider_banner' => __SOURCE__ . 'images/ProviderToStartup/',
	];
	
	
	public function universalProviders() {
		/** @var StartupsEntity $startup */
		$startup = \model\Startups::getByToken(get_header('token'));
		return $this->model()::getAllFiltered("startup_id", $startup->id)->reject(function ($item) {
			return !$item->is_universal;
		})->map(function ($item) {
			/** @var ProvidersEntity $provider */
			$provider = \model\Providers::get($item->provider_id);
			return [
				'id'       => $item->provider_id,
				'provider' => $provider->apiFormat(),
				'banner'   => __IMAGES__ . 'ProviderToStartup/' . $item->provider_banner,
				'branches' => collect(json_decode($item->provider_branch_id, true))->map(function ($id) {
					return \model\ProviderBranches::get($id)->ApiFormat();
				}),
			];
		});
	}
	
	public function getProviders($startupId, $cityId, $casteId, $sortBy, $sortType, $page = 0, $limit = 10) {
		if (!$page) $page = 0;
		$startup = \model\Startups::getByToken($startupId);
		[
			$count,
			$data,
		] = \model\ProviderToStartup::getProviderList($startup, $cityId, $casteId, $sortBy, $sortType, $page, $limit);
		return [
			$count,
			$data->map(function ($item) {
				$entity = ProviderToStartupEntity::fromArray((array)$item);
				return $entity->apiFormat();
			})->values(),
		];
		return $this->model()::Db()->where("startup_id", $startup->id)->get()->
		filter(function (ProviderToStartupEntity $item) use ($casteId) {
			/** @var ProvidersEntity $provider */
			$provider = \model\Providers::get($item->provider_id);
			return $provider->caste_id == $casteId and $item->to_startup_cash_discount > 0;
		})->filter(function (ProviderToStartupEntity $providers_entity) use ($cityId) {
			return \model\ProviderBranches::Db()->where([
					"city_id"     => "$cityId",
					'provider_id' => "$providers_entity->provider_id",
				])->limit(1)->get()->first instanceof ProviderBranchesEntity;
		})->
		map(function (ProviderToStartupEntity $item) {
			return $item->apiFormat();
		})->values();
	}
	
	public function single(?string $startupId, $id) {
		/** @var StartupsEntity $startup */
		$startup = \model\Startups::getByToken($startupId);
		/** @var ProviderToStartupEntity $providerToStartup */
		$providerToStartup = \model\ProviderToStartup::Db()->where([
			'provider_id' => $id,
			'startup_id'  => $startup->id,
		])->get()->first;
		\model\ProviderToStartup::edit($providerToStartup->provider_to_startup_id, [
			'provider_view' => $providerToStartup->provider_view + 1,
		]);
		$providerToStartup = \model\ProviderToStartup::get($providerToStartup->provider_to_startup_id);
		return $providerToStartup->singleApiFormat();
	}
}
