<?php
namespace controller;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\ProductsNameEntity;

class ProductsName extends ControllerScheme {
    const name = 'نام محصول';

    public static $__uploads = ["product_image" => __SOURCE__."images/ProductsName/"];

    public function getProductWithSubSubGroup() {
        $subsubId = $this->requestArray()['product_sub_sub_group_id'];
        $output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
        foreach ($this->productBySubSubId($subsubId) as $product) {
            if (isActive($this,$product)) {
                $output[] = HtmlTags::Option()->Value($product->product_sub_sub_group_id)->Content($product->product_sub_sub_group_name);
            }
        }
        return implode('', $output);
    }

    private function productBySubSubId($subsubId) {
        $output = [];
        foreach ($this->model()::getAllFiltered('product_sub_sub_group_id', "$subsubId") as $product) {
            if (!($product instanceof ProductsNameEntity)){
                $product = ProductsNameEntity::fromArray((array)$product);
            }
            $output[] = $product;
        }
        return $output;
    }
}