<?php

namespace controller;

use ControllerScheme;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;

class Levels extends ControllerScheme {
	const name = 'مرحله';
	public static $__uploads = ["level_image" => __SOURCE__ . "images/Levels/"];
	
	public function getActiveLevels() {
		
		return $this->model()::getAllActives()->map(function (LevelsEntity $entity) {
			return $entity->apiFormat();
		});
	}
	
	public function getSubsetInputs() {
		$startupId = $this->requestArray('startup_id');
		/** @var StartupsEntity $startup */
		$startup = \model\Startups::get($startupId);
		$Levels = new Levels();
		
//		$Levels->loadView();
		
		$levelsView = new \view\Levels($Levels);
		return $levelsView->buildSubSetPercents($startup->referral_count);
	}
	
}
