<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwConnection;
use model\Entity\CustomersEntity;

class Customers extends ControllerScheme
{
    use ApiInterface;

    const name = 'مشتری';
    public static $__uploads = ["customer_image" => __SOURCE__ . "images/Customers/"];

    public function init() {
        $mobile = str_replace(' ', '', (trim($this->ApiParam('customerMobile'))));
        /** @var CustomersEntity $customer */
        $customer = $this->model()::getOneFiltered('customer_mobile', $mobile);
        if ($customer and $customer->status > 0) {
            if ($customer->password != '') {
                return ['type' => 'login', 'has_password' => true, 'result' => true];
            } else {
                $code = generateRandomString(6, true);
                if (sendVerify($mobile, [$code])) {
                    \model\Customers::edit($customer->customer_id, ['customer_code' => $code]);
                    return [
                        'type'         => 'login',
                        'has_password' => false,
                        'result'       => true,
                        'code'         => $code,
                    ];
                } else {
                    return ['type' => 'login', 'has_password' => false, 'result' => false];
                }
            }
        } else {
            $code = generateRandomString(6, true);
            if (sendVerify($mobile, [$code])) {
                \model\Customers::Db()->where("customer_mobile", $mobile)->delete();
                $customerData = [
                    'customer_code'       => $code,
                    'customer_mobile'     => $mobile,
                ];
                $this->model()->add($customerData);
                return ['type' => 'register', 'result' => true];
            } else {
                return ['type' => 'register', 'result' => false];
            }
        }
    }
    public function loginWithPass() {
        $mobile = str_replace(' ', '', (trim($this->ApiParam('customerMobile'))));
        $password = str_replace(' ', '', (trim($this->ApiParam('customerPassword'))));
        $password = sha1(md5($password));
        $customer = $this->model()::Db()->where([
            'customer_mobile'   => $mobile,
            'customer_password' => $password,
            'customer_status'   => 1,
        ])->get()->first();
        return $this->outputCustomer($customer);
    }
    public function loginWithCode() {
        $mobile = str_replace(' ', '', (trim($this->ApiParam('customerMobile'))));
        $code = str_replace(' ', '', (trim($this->ApiParam('customerCode'))));
        /** @var CustomersEntity $customer */
        $customer = $this->model()::Db()->where([
            'customer_mobile' => $mobile,
            'customer_code'   => $code,
            'customer_status' => 1,
        ])->get()->first();
        return $this->outputCustomer($customer);
    }
    public function registerWithCode() {
        $mobile = str_replace(' ', '', (trim($this->ApiParam('customerMobile'))));
        $code = str_replace(' ', '', (trim($this->ApiParam('customerCode'))));
        /** @var CustomersEntity $customer */
        $customer = $this->model()::Db()->where([
            'customer_mobile' => $mobile,
            'customer_code'   => $code,
            'customer_status' => 0,
        ])->get()->first();
        \model\Customers::edit($customer->customer_id, [
            'customer_status' => 1,
        ]);
        return $this->outputCustomer($customer);
    }
    private function outputCustomer($customer) {
        if ($customer) {
            return [
                'type'   => 'done',
                'result' => true,
                'data'   => $this->apiFormat($customer->{$this->Key()}),
            ];
        } else {
            return ['type' => 'wrong_password', 'result' => false];
        }
    }
    public function apiFormat($customerId) {
        if ($customerId > 0) {
            $data = $this->model()::get($customerId);
            /** @var CustomersEntity $data */
            if ($data) {
                // Controller
                return [
                    'customerId'        => "$data->customer_id",
                    'customerMobile'    => "$data->mobile",
                    'supportUrl'        => "tel://02191071230",
                    'customerFirstName' => (strlen($data->first_name) > 0 ? $data->first_name : ""),
                    'customerLastName'  => (strlen($data->last_name) > 0 ? $data->last_name : ""),
                    'customerCredit'    => $data->credit,
                    'gender'            => $data->gender,

                ];
            }
        }
        return NULL;
    }	public function showInOption(object $item) : string {
    return ($item->customer_id . ' - ' . $item->first_name . ' ' . $item->last_name . ' - ' . $item->mobile);

}






    public function getMobile()
    {
        $id = $_POST['id'];
        $startUp = $_POST['startUp'];
        $res = FwConnection::conn()->query("select * from tblStartupUsers where `customer_id` ='$id' AND `startup_id` ='$startUp'")->rowCount();
        if ($res >= 1) {
            return 'again';
        } else {
            $individualId = $this->model()::get($_POST['id'])->individual_id;
            $mobile = \model\Individuals::get($individualId)->individual_mobile;
            return $mobile;
        }
    }

    public function getCustomersNotInStartup()
    {
        $startUp = $_POST['startup_id'];
        $query = FwConnection::conn()->query("SELECT * FROM tblCustomers WHERE customer_id NOT IN (SELECT `tblStartupUsers`.`customer_id` FROM `tblStartupUsers` WHERE startup_id='$startUp')")->fetchAll();
        $res = '<option value="" selected disabled>لطفا یک مورد را انتخاب کنید</option>';
        foreach ($query as $item) {
            $mobile = \model\Individuals::get($item['individual_id'])->individual_mobile;
            $res .= '<option  value="' . $item['customer_id'] . '">' . $item['customer_fname'] . ' ' . $item['customer_lname'] . '_' . $mobile . '</option>';
        }
        return $res;
    }

    public function customerScoreAndCredit()
    {
        $res = [];
        $customer = $this->model()::get($_POST['id']);

        $res['score'] = $customer->customer_score;
        $res['credit'] = $customer->customer_credit;

        return json_encode($res);

    }

//  public function init(){
//
//        $customerMobile = $this->ApiParam('customerMobile') ;
//        $res = FwConnection::conn()->query("SELECT * FROM tblCustomers where customer_mobile='$customerMobile' ")->rowCount();
//
//        if ($res > 0 ){
//
//               $password = FwConnection::conn()->query("SELECT customer_password FROM tblCustomers where customer_mobile='$customerMobile' ")->fetchObject();
////               if($password!=''){
////                   return ['type' => 'login', 'has_password' => true, 'result' => true];
////               }
////               else{
//                   $code = generateRandomString(6, true);
//                   var_dump($code);
//                   sendVerify($customerMobile,[$code]);
//                   $update_code=FwConnection::conn()->query("UPDATE tblCustomers SET customer_sms='$code' where customer_mobile='$customerMobile' ")->fetchObject();
//
////            return "login" ;
//        }
//
//        else{
//            //register
//            $code = generateRandomString(6, true);
//            sendVerify($customerMobile,[$code]);
//            $customerId = \model\Customers::add([
//                'customer_mobile'=> $customerMobile,
//                'customer_sms'=> $code,
//            ]);
//return "register" ;
//
//
//        }
//
//
//
//    }

}