<?php

namespace controller;

use ControllerScheme;
use Api\ApiInterface;
use model\Entity\CustomersEntity;
use model\Entity\CreditCardsEntity;

class CreditCards extends ControllerScheme {
	use ApiInterface;
	
	const name = 'کارت های بانکی';
	
	
	public function allCards() {
		$customerId = $this->ApiParam('customerId');
		$customer = \model\Customers::get($customerId);
		if ($customer instanceof CustomersEntity) {
			$this->setIsDone();
			return $this->model()::getAllFiltered("customer_id",$customerId)->map(function (CreditCardsEntity $card){
				return $card->apiFormat();
			});
		} else {
			return "مشتری یافت نشد";
		}
	}
}
