<?php

namespace controller;

use FwConfig;
use ControllerScheme;
use Api\ApiInterface;
use model\Entity\StartupsEntity;
use model\Entity\HotelServicesEntity;

class HotelServices extends ControllerScheme {
	use ApiInterface;
	
	const name = 'سرویس هتل';
	
	
	public function DestinationList() {
		$startup = $this->ApiParam('startupToken');
		$token = FwConfig::FlightToken();
		$startup = \model\Startups::getByToken($startup);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof HotelServicesEntity) {
				$result = json_decode(CallAPI('post', "http://api.hiholiday.ir/V4/Accommodation/Regions/$token"));
				if ($result->Regions) {
					return [
						'status'  => true,
						'regions' => $result->Regions,
					];
				}
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToHotelService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
		return [
			'status'  => false,
			'message' => 'RegionsEmpty',
		];
	}
	
	public function HotelList() {
		$startup = $this->ApiParam('startupToken');
		$destination = $this->ApiParam('destination');
		$dates = $this->ApiParam('dates');
		$startDate = explode(',', $dates)[0];
		$endDate = explode(',', $dates)[1];
		$token = FwConfig::FlightToken();
		$startup = \model\Startups::getByToken($startup);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof HotelServicesEntity) {
				$result = json_decode(CallAPI('post', "http://api.hiholiday.ir/V4/Accommodation/Search/$token", [
					'Adult'        => [1],
					'Child'        => [0],
					'RegionId'     => $destination,
					'ChildAge'     => [0],
					'CheckinDate'  => $startDate,
					'CheckoutDate' => $endDate,
				]));
				if ($result->Accommodations) {
					return [
						'status'         => true,
						'accommodations' => $result->Accommodations,
					];
				}
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToHotelService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
		return [
			'status'         => true,
			'accommodations' => [],
			'message'        => $result,
		];
	}
}
