<?php

namespace controller;

use FwConfig;
use ControllerScheme;
use Api\ApiInterface;
use model\Entity\StartupsEntity;
use model\Entity\FlightServicesEntity;

class FlightServices extends ControllerScheme {
	use ApiInterface;
	
	const name = 'سرویس پرواز';
	
	
	public function GetAirports() {
		$token = FwConfig::FlightToken();
		$startup = $this->ApiParam('startupToken');
		$startup = \model\Startups::getByToken($startup);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof FlightServicesEntity) {
				$api = CallAPI('get', "http://api.hiholiday.ir/v4/region/airport/$token");
				return [
					'status'   => true,
					'airports' => collect(json_decode($api, true)['Airports'])->map(function ($item) {
						return [
							'typeId'   => $item['RegionTypeID'],
							'enName'   => $item['RegionName'],
							'faName'   => $item['FaRegionName'],
							'longName' => $item['RegionNameLong'],
							'code'     => $item['Code'],
							'enParent' => $item['ParentRegionName'],
							'faParent' => $item['FaParentRegionName'],
						];
					}),
				];
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToFlightService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
	
	public function SearchDeparture() {
		$startup = $this->ApiParam('startupToken');
		$origin = $this->ApiParam('origin');
		$destination = $this->ApiParam('destination');
		$date = $this->ApiParam('date');
		$count = $this->ApiParam('count');
		$page = $this->ApiParam('page');
		$token = FwConfig::FlightToken();
		$startup = \model\Startups::getByToken($startup);
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof FlightServicesEntity) {
				$result = json_decode(CallAPI('get', "http://api.hiholiday.ir/V4/Flight/OneWay/$token/$origin/$destination/$date/$count/10/$page"));
				if ($result->DepartureFlights) {
					return $result->DepartureFlights;
				}
				return [];
			} else {
				return [
					'status'  => false,
					'message' => 'noAccessToFlightService',
				];
			}
		} else {
			return [
				'status'  => false,
				'message' => 'startUpNotFound',
			];
		}
	}
}
