<?php

namespace controller;

use fwJson\Json;
use MobinOneCharges;
use ControllerScheme;
use Api\ApiInterface;
use model\PaymentTable;
use payment\BasePayment;
use FwCharge\ChargeClass;
use model\Entity\StartupsEntity;
use site\helpers\ParsianPayment;
use model\Entity\CustomersEntity;
use model\Entity\SimCardNumbersEntity;
use model\Entity\ChargeServicesEntity;
use model\Entity\ChargeOperatorsEntity;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

class ChargeServices extends ControllerScheme {
	use ApiInterface;
	
	const name = 'سرویس شارژ';
	
	
	public function initChargeService() {
		$startupToken = $this->ApiParam('startupToken');
		$operatorId = $this->ApiParam('operatorId');
		$chargeAmount = $this->ApiParam('chargeAmount');
		$mobile = $this->ApiParam('mobile');
		$callBack = $this->ApiParam('callback');
		$output = ['status' => false,];
		if (!($startupToken and (\model\Startups::getByToken($startupToken) instanceof StartupsEntity))) {
			$output['message'] = 'StartupNotFound';
			return $output;
		}
		if (!($operatorId and (\model\ChargeOperators::getByOperatorCode($operatorId) instanceof ChargeOperatorsEntity))) {
			$output['message'] = 'OperatorNotFound';
			return $output;
		}
		if (!$mobile) {
			$output['message'] = 'MobileNotSet';
			return $output;
		} elseif (!(\model\Customers::getByMobile($mobile) instanceof CustomersEntity)) {
			$customer = \model\Customers::get(\model\Customers::quickAddMobile($mobile));
		} else {
			$customer = \model\Customers::getByMobile($mobile);
		}
		$Payment = new ParsianPayment();
		$Payment->UserModel(new \model\Customers(), $customer);
		$Payment->initPayment(new PaymentTable())->Amount($chargeAmount)->Type(ChargeClass::buyChargePayType);
		$Payment->OrderData(Json::encode([
			'callback' => $callBack,
		]));
		$ChargeClass = new ChargeClass();
		$url = $Payment->goToPayment();
		$reserve = $ChargeClass->reserve($Payment, $operatorId);
		if (filter_var($url, FILTER_VALIDATE_URL)) {
			$output['status'] = true;
			$output['url'] = $url;
		} else {
			$output['message'] = $url;
		}
		return $output;
	}
	
	public function chargePaymentCallBack($post, BasePayment $Payment, $PaymentData) {
		$resNum = $post['OrderId'];
		$Status = $post['status'];
		$refNum = $post['RRN'];
		$Token = $post['Token'];
		if ($Status === '0' and $PaymentData->payment_status <= 0) {
			$Payment->update($resNum, $refNum);
			$Payment->Confirm($Token);
			$customer_id = $PaymentData->customer_id;
			/** @var CustomersEntity $customer */
			$customer = \model\Customers::get($customer_id);
			$chargeServices = new ChargeServices();
			$operator = $chargeServices->operatorFinder($customer->mobile);
			$charge = MobinOneCharges::buyCharge($operator['id'], $PaymentData->payment_amount, $customer->mobile, $resNum);
			ChargeClass::Update($resNum, '1');
			return $this->CallCallBack($resNum, true, $PaymentData);
		} else {
			ChargeClass::Update($resNum, $Status === '1' ? '0' : $Status);
			return $this->CallCallBack($resNum, false, $PaymentData);
		}
	}
	
	public function operatorFinder($mobile) {
		
		$mobile = $mobile[2] . $mobile[3];
		/** @var SimCardNumbersEntity $simNumber */
		foreach (\model\SimCardNumbers::getAll() as $simNumber) {
			if ($simNumber->number == $mobile) {
				/** @var ChargeOperatorsEntity $operator */
				$operator = \model\ChargeOperators::get($simNumber->charge_operator_id);
				return $operator->apiFormat();
			}
		}
		return NULL;
	}
	
	private function CallCallBack($resNum, bool $status, $PaymentData) {
		$mobile = $PaymentData->mobile;
		$status = $status ? 'true' : 'false';
		return "<form action='{$this->getCallBackUrl($resNum)}' id='SubmitForm' method='post' >
<input type='hidden' name='status' value='$status'>
<input type='hidden' name='mobile' value='$mobile'>
<input type='hidden' name='resNum' value='$resNum'>
</form>
 <script>document.getElementById('SubmitForm').submit();</script>
";
	}
	
	private function CallCallBackForPackage($resNum, bool $status, $PaymentData) {
		$mobile = $PaymentData->mobile;
		$status = $status ? 'true' : 'false';
		return "<form action='{$this->getCallBackUrlForPackage($resNum)}' id='SubmitForm' method='post' >
<input type='hidden' name='status' value='$status'>
<input type='hidden' name='mobile' value='$mobile'>
<input type='hidden' name='resNum' value='$resNum'>
</form>
 <script>document.getElementById('SubmitForm').submit();</script>
";
	}
	
	private function getCallBackUrl($resNum) {
		$Db = new Db('ChargesTable');
		return $Db->where("charge_resnum", $resNum)->get()->first()->callback;
	}
	
	private function getCallBackUrlForPackage($resNum) {
		$Db = new Db('InternetPackagesTable');
		return $Db->where("charge_resnum", $resNum)->get()->first()->callback;
	}
	
	public function packagePaymentCallBack($post, BasePayment $Payment, $PaymentData) {
		$resNum = $post['OrderId'];
		$Status = $post['status'];
		$refNum = $post['RRN'];
		$Token = $post['Token'];
		$Db = Db::table('InternetPackagesTable')->where('payment_id',$PaymentData->payment_id)->get()->first;
		if ($Status === '0' and $PaymentData->payment_status <= 0) {
			$Payment->update($resNum, $refNum);
			$Payment->Confirm($Token);
			$customer_id = $PaymentData->customer_id;
			/** @var CustomersEntity $customer */
			$customer = \model\Customers::get($customer_id);
			$chargeServices = new ChargeServices();
			$operator = $chargeServices->operatorFinder($customer->mobile);
			$charge = MobinOneCharges::buyPackage($operator['id'], $Db->package_code,$Db->package_cost,$Db->mobile,$resNum);
			ChargeClass::UpdateInternetPackage($resNum, '1');
			return $this->CallCallBackForPackage($resNum, true, $PaymentData);
		} else {
			ChargeClass::UpdateInternetPackage($resNum, $Status === '1' ? '0' : $Status);
			return $this->CallCallBackForPackage($resNum, false, $PaymentData);
		}
	}
	
	public function PackageList() {
		$startup = get_header('token');
		$startup = \model\Startups::getByToken("$startup");
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof ChargeServicesEntity) {
				$this->setIsDone();
				return [
					'status' => true,
					'data'   => [
						[
							'id'             => 1,
							'name'           => 'بسته ی تست',
							'traffic'        => '10 مگابایت',
							'duration'       => '۳۰ روز',
							'amount'         => 10000,
							'suppliedAmount' => 12000,
						],
						[
							'id'             => 2,
							'name'           => 'بسته ی تست 2',
							'duration'       => '15 روز',
							'traffic'        => '5 مگابایت',
							'amount'         => 5000,
							'suppliedAmount' => 7500,
						],
					],
				];
			} else {
				return response(['message' => 'noAccessToCarService'], 404);
			}
		} else {
			return response(['message' => 'startUpNotFound'], 404);
		}
	}
	
	public function OperatorList() {
		$startup = get_header('startupToken');
		if (!$startup) return ['status' => false, 'message' => 'tokenNotSet'];
		$startup = \model\Startups::getByToken("$startup");
		$output = [
			'status'  => false,
			'message' => 'unknownError',
		];
		if ($startup instanceof StartupsEntity) {
			if ($this->model()::getOneFiltered("startup_id", $startup->id) instanceof ChargeServicesEntity) {
				$output['status'] = true;
				unset($output['message']);
				$output['data'] = \model\ChargeOperators::getAll()->map(function (ChargeOperatorsEntity $entity) {
					return $entity->apiFormat();
				});
			} else {
				$output['message'] = 'noAccessToChargeService';
			}
		} else {
			$output['message'] = 'startUpNotFound';
		}
		return $output;
	}
	
	
}
