<?php

namespace controller;

use ControllerScheme;
use model\Entity\StatesEntity;
use model\Entity\CastesEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class States extends ControllerScheme implements \CrudService {
	const name = 'استان';
	
	
	public function getStateInCountry() {
		$countryId = $this->requestArray()['country_id'];
		$output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
		foreach ($this->StateBycountrieId($countryId) as $state) {
			if (isActive($this, $state)) {
				$output[] = HtmlTags::Option()->Value($state->state_id)->Content($state->state_name);
			}
		}
		return implode('', $output);
	}
	
	private function StateBycountrieId($countryId) {
		$output = [];
		foreach ($this->model()::getAllFiltered('country_id', "$countryId") as $state) {
			if (!($state instanceof StatesEntity)) {
				$state = StatesEntity::fromArray((array)$state);
			}
			$output[] = $state;
		}
		return $output;
	}
	
	public function getActiveCities() {
		$output = [];
		foreach ($this->model()::getAllActives() as $city) {
			/** @var StatesEntity $city */
			$output[] = $city;
		}
		return $output;
	}
	
	public function canDelete() : bool {
		return false;
	}
	
	public function canUpdate() : bool {
		return false;
	}
	
	public function canReadOne() : bool {
		return true;
	}
	
	public function canReadAll() : bool {
		return true;
	}
	
	public function canCreate() : bool {
		return false;
	}
	
	public function onReadAll() {
		return function () {
			return response(self::model()::getAllActives()->map(function (StatesEntity $state) {
				return $state->apiFormat();
			}));
		};
	}
	
	public function onReadOne(int $id) {
		return function () use ($id) {
			$state = $this->model()::get($id);
			return response($state instanceof StatesEntity ? $state->apiFormat() : NULL, $state instanceof StatesEntity ? 200 : 404);
		};
	}
	
	public function onReadAllFiltered($filterField, $filterValue) {
		return function () {
			return response($this->model()::getAllActives()->map(function (CastesEntity $caste) {
				return $caste->apiFormat();
			}));
		};
	}
}
