<?php
namespace controller;
use ControllerScheme;
use model\Entity\CastesEntity;
use model\Entity\CountriesEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\DistrictsEntity;

class Countries extends ControllerScheme implements \CrudService {
    const name = 'کشور';
	
	public function canDelete() : bool {
		return false;
	}
	
	public function canUpdate() : bool {
		return false;
	}
	
	public function canReadOne() : bool {
		return true;
	}
	
	public function canReadAll() : bool {
		return true;
	}
	
	public function canCreate() : bool {
		return true;
	}
	
	public function onReadAll() {
		return function () {
			return response($this->model()::getAllActives()->map(function (CountriesEntity $country) {
				return $country->apiFormat();
			}));
		};
	}
	
	public function onReadOne(int $id) {
		return function () use ($id) {
			$country = $this->model()::get($id);
			return response($country instanceof CountriesEntity ? $country->apiFormat() : NULL, $country instanceof CountriesEntity ? 200 : 404);
		};
	}
	
	public function onReadAllFiltered($filterField, $filterValue) {
		return function () use ($filterField, $filterValue) {
			return NULL;
		};
	}

}

