<?php

namespace controller;

use ControllerScheme;
use model\Entity\CitiesEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Cities extends ControllerScheme implements \CrudService {
	
	const name = 'شهر';
	
	
	public function getCityInState() {
		$stateId = $this->requestArray()['state_id'];
		$output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
		foreach ($this->cityByStateId($stateId) as $city) {
			if (isActive($this, $city)) {
				$output[] = HtmlTags::Option()->Value($city->city_id)->Content($city->name);
			}
		}
		return implode('', $output);
	}
	
	private function cityByStateId($cityId) {
		$output = [];
		foreach ($this->model()::getAllFiltered('state_id', "$cityId") as $city) {
			if (!($city instanceof CitiesEntity)) {
				$city = CitiesEntity::fromArray((array)$city);
			}
			$output[] = $city;
		}
		return $output;
	}
	
	public function getActiveCities($stateId) {
		return $this->model()::getAllActives()->filter(function (CitiesEntity $cities_entity) use ($stateId) {
			return $cities_entity->state_id == $stateId || $stateId == 0;
		})->map(function (CitiesEntity $entity) {
			return $entity->apiFormat();
		})->values();
	}
	
	
	public function canDelete() : bool {
		return false;
	}
	
	public function canUpdate() : bool {
		return false;
	}
	
	public function canReadOne() : bool {
		return true;
	}
	
	public function canReadAll() : bool {
		return true;
	}
	
	public function canCreate() : bool {
		return false;
	}
	
	public function onReadAll() {
		return function () {
			return response(self::model()::getAllActives()->map(function (CitiesEntity $city) {
				return $city->apiFormat();
			}));
		};
	}
	
	public function onReadOne(int $id) {
		return function () use ($id) {
			$city = $this->model()::get($id);
			return response($city instanceof CitiesEntity ? $city->apiFormat() : NULL, $city instanceof CitiesEntity ? 200 : 404);
		};
	}
	
	public function onReadAllFiltered($filterField, $filterValue) {
		return function () use ($filterField, $filterValue) {
			return response($this->model()::getAllFiltered($filterField, $filterValue)->filter(function ($item) {
				return isActive($this, $item);
			})->map(function (CitiesEntity $city) {
				return $city->apiFormat();
			}));
		};
	}
}
