<?php

namespace controller;

use ControllerScheme;
use model\Entity\IdentificationSeriesEntity;

class IdentificationSeries extends ControllerScheme implements \CrudService {
	const name = 'سریال شناسنامه';
	
	public function canDelete() : bool {
		return false;
	}
	
	public function canUpdate() : bool {
		return false;
	}
	
	public function canReadOne() : bool {
		return true;
	}
	
	public function canReadAll() : bool {
		return true;
	}
	
	public function canCreate() : bool {
		return true;
	}
	
	public function onReadAll() {
		return function () {
			return response($this->model()::getAll()->map(function (IdentificationSeriesEntity $identificationSerial) {
				return $identificationSerial->apiFormat();
			}));
		};
	}
	
	public function onReadOne(int $id) {
		return function () use ($id) {
			$identificationSerial = $this->model()::get($id);
			return response($identificationSerial instanceof IdentificationSeriesEntity ? $identificationSerial->apiFormat() : NULL, $identificationSerial instanceof IdentificationSeriesEntity ? 200 : 404);
		};
	}
	
	public function onReadAllFiltered($filterField, $filterValue) {
		return function () use ($filterField, $filterValue) {
			return NULL;
		};
	}
	
}
