<?php

namespace controller;

use CrudService;
use Api\ApiInterface;
use ControllerScheme;
use model\Entity\CastesEntity;
use model\Entity\WorkGroupsEntity;

class WorkGroups extends ControllerScheme implements CrudService {
	const name = 'workgroup_id';
	
	use ApiInterface;
	
	public static $__uploads = [
		"work_group_icon"  => __SOURCE__ . "images/WorkGroups/",
		"work_group_image" => __SOURCE__ . "images/WorkGroups/",
	];

//    public function allWorkgroup(){
//        $res=\FwConnection::conn()->query("SELECT * FROM tblWorkGroups ")->fetchAll() ;
//        return $res ;
//    }
	public function allWorkgroup() {
		return $this->model()::getAllActives()->map(function (WorkGroupsEntity $entity) {
			return $entity->apiFormat();
		});
	}
	
	public function canDelete() : bool {
		return false;
	}
	
	public function canUpdate() : bool {
		return false;
	}
	
	public function canReadOne() : bool {
		return true;
	}
	
	public function canReadAll() : bool {
		return true;
	}
	
	public function canCreate() : bool {
		return true;
	}
	
	public function onReadAll() {
		return function () {
			return response($this->model()::getAllActives()->map(function (WorkGroupsEntity $work_groups_entity) {
				return $work_groups_entity->apiFormat();
			}));
		};
	}
	
	public function onReadOne(int $id) {
		return function () use ($id) {
			$workGroup = $this->model()::get($id);
			return response($workGroup instanceof WorkGroupsEntity ? $workGroup->apiFormat() : NULL, $workGroup instanceof WorkGroupsEntity ? 200 : 404);
		};
	}
	
	public function onReadAllFiltered($filterField, $filterValue) {
		return function () use ($filterField, $filterValue) {
			return response($this->model()::getAllActives()->map(function (CastesEntity $caste) {
				return $caste->apiFormat();
			}));
		};
	}
}
