<?php

namespace controller;

use ControllerScheme;
use Api\ApiInterface;
use model\Entity\CastesEntity;
use model\Entity\CitiesEntity;
use model\Entity\ProvidersEntity;
use model\Entity\WorkGroupsEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwPagination\Controllers\ControllersPagination;

class Castes extends ControllerScheme implements \CrudService {
	const name = 'اصناف';
	use ControllersPagination;
	use ApiInterface;
	public static $__uploads = ["caste_icon" => __SOURCE__."images/Castes/"];
	
	public function getCaseInWorkGroup() {
		$workgroupId = $this->requestArray()['workgroup_id'];
		$output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
		foreach ($this->caseByWorkGroupId($workgroupId) as $case) {
			if (isActive($this, $case)) {
				$output[] = HtmlTags::Option()->Value($case->caste_id)->Content($case->caste_name);
			}
		}
		return implode('', $output);
	}
	
	private function caseByWorkGroupId($caseId) {
		$output = [];
		foreach ($this->model()::getAllFiltered('workgroup_id', "$caseId") as $case) {
			if (!($case instanceof CastesEntity)) {
				$case = CastesEntity::fromArray((array)$case);
			}
			$output[] = $case;
		}
		return $output;
	}
	
	public function allCastes($workgroup) {
		
		return ($workgroup > 0 ? $this->model()::getAllFiltered('workgroup_id', "$workgroup") : $this->model()::getAllActives())->filter(function ($item) {
			return isActive($this, $item);
		})->map(function (CastesEntity $entity) {
			return $entity->apiFormat();
		})->values();
	}
	
	public function casteByProvider(int $providerId) {
		/** @var ProvidersEntity $provider */
		$provider = \model\Providers::get($providerId);
		/** @var CastesEntity $caste */
		$caste = \model\Castes::get($provider->caste_id);
		return $caste instanceof CastesEntity ? $caste->apiFormat() : ['message' => 'caste not found'];
	}
	
	
	public function canDelete() : bool {
		return false;
	}
	
	public function canUpdate() : bool {
		return false;
	}
	
	public function canReadOne() : bool {
		return true;
	}
	
	public function canReadAll() : bool {
		return true;
	}
	
	public function canCreate() : bool {
		return true;
	}
	
	public function onReadAll() {
		return function () {
			return response($this->model()::getAllActives()->map(function (CastesEntity $caste) {
				return $caste->apiFormat();
			}));
		};
	}
	
	public function onReadOne(int $id) {
		return function () use ($id) {
			$caste = $this->model()::get($id);
			return response($caste instanceof CastesEntity ? $caste->apiFormat() : NULL, $caste instanceof WorkGroupsEntity ? 200 : 404);
		};
	}
	
	public function onReadAllFiltered($filterField, $filterValue) {
		return function () use ($filterField, $filterValue) {
			return response($this->model()::getAllFiltered($filterField, $filterValue)->filter(function ($item) {
				return isActive($this, $item);
			})->map(function (CastesEntity $caste) {
				return $caste->apiFormat();
			})->values());
		};
	}
}
