<?php
ini_set('session.save_path', '/tmp');
ini_set('error_reporting', E_ALL);
ini_set('display_errors', E_ALL);

use model\PaymentTable;
use FwCharge\ChargeClass;
use FwRoutingSystem\Router;
use site\helpers\ParsianPayment;

include 'src/autoload.php';

define('__HOST__', FwConfig::HOST());
define('__IMAGES__', 'https://img.negahub.com/');
$Router = new Router();

$Router->any('/Callback', function () {
	$resNum = $_POST['OrderId'];
	if (!$resNum) $resNum = $_POST['resNum'];
	$Status = $_POST['status'];
	$refNum = $_POST['RRN'];
	$Token = $_POST['Token'];
	$Payment = new ParsianPayment();
	$Payment->initPayment(new PaymentTable());
	$PaymentData = $Payment->PaymentModel::getOneFiltered($Payment->PaymentModel->ResNumField(), $resNum);
	switch ($PaymentData->payment_type) {
		case ChargeClass::buyChargePayType:
			return (new controller\ChargeServices)->chargePaymentCallBack($_POST, $Payment, $PaymentData);
			break;
		case ChargeClass::buyPackagePayType:
			return (new controller\ChargeServices)->packagePaymentCallBack($_POST, $Payment, $PaymentData);
			break;
		case 'provider_payment':
			return (new controller\ProviderPayments())->paymentCallBack($_POST, $Payment, $PaymentData);
			break;
		default:
			break;
	}
});
$Router->get('/mobt', function () {
	header('Content-type: application/xml');
	return CallAPI('get', 'https://echarge.mobtakerancell.com/TopUp/ChargeSrv.svc?singleWsdl');
});
$Router->get('/caste-test',function (){set_time_limit(0);


});
$Router->get('/mobin', function () {
	var_dump('hi');
});
$Router->get('/charge/:id', function ($amount) {
	var_dump(FwConfig::BehpardakhtToken());
});
$Router->__defaults();
